#include <bits/stdc++.h>
using namespace std;

struct SweepEvent {
    long double angle;
    int idx;    
    int delta;   
};

static const long double PI = acosl(-1.0L);
static const long double TWO_PI = 2.0L * PI;

static long double normalizeAngle(long double a) {
    a = fmodl(a, TWO_PI);
    if (a < 0) a += TWO_PI;
    return a;
}

static bool sameAngle(long double a, long double b) {
    return fabsl(a - b) <= 1e-18L;
}

static long double dotWithDirection(long double theta, long long sx, long long sy) {
    long double ux = cosl(theta), uy = sinl(theta);
    return ux * (long double)sx + uy * (long double)sy;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n + 1), y(n + 1);
    vector<char> isActive(n + 1, 0); 
    vector<SweepEvent> events;
    events.reserve(2LL * n);

    long long sumX = 0, sumY = 0;

    for (int i = 1; i <= n; i++) {
        cin >> x[i] >> y[i];
        if (x[i] == 0 && y[i] == 0) continue;

        if (x[i] > 0) {
            isActive[i] = 1;
            sumX += x[i];
            sumY += y[i];
        }

        long double phi = atan2l((long double)y[i], (long double)x[i]);

        long double enterAngle = normalizeAngle(phi - PI / 2);
        long double leaveAngle = normalizeAngle(phi + PI / 2);

        events.push_back({enterAngle, i, +1});
        events.push_back({leaveAngle, i, -1});
    }

    sort(events.begin(), events.end(), [](const SweepEvent& a, const SweepEvent& b) {
        if (a.angle != b.angle) return a.angle < b.angle;
        return a.delta > b.delta;
    });

    long double bestTheta = 0;
    long double bestValue = -1;

    auto considerInterval = [&](long double L, long double R, long long sx, long long sy) {
        if (sx == 0 && sy == 0) return;

        long double preferred = normalizeAngle(atan2l((long double)sy, (long double)sx));
        long double length = hypotl((long double)sx, (long double)sy);

        if (L < preferred && preferred < R) {
            if (length > bestValue) {
                bestValue = length;
                bestTheta = preferred;
            }
            return;
        }

        long double vL = dotWithDirection(L, sx, sy);
        long double vR = dotWithDirection(R, sx, sy);

        if (vL > bestValue) { bestValue = vL; bestTheta = L; }
        if (vR > bestValue) { bestValue = vR; bestTheta = R; }
    };

    long double prevAngle = 0.0L;

    for (int it = 0; it < (int)events.size(); ) {
        long double curAngle = events[it].angle;

        if (curAngle > prevAngle + 1e-18L) {
            considerInterval(prevAngle, curAngle, sumX, sumY);
        }

        while (it < (int)events.size() && sameAngle(events[it].angle, curAngle)) {
            int id = events[it].idx;
            int delta = events[it].delta;

            if (delta == +1) {
                if (!isActive[id]) {
                    isActive[id] = 1;
                    sumX += x[id];
                    sumY += y[id];
                }
            } else {
                if (isActive[id]) {
                    isActive[id] = 0;
                    sumX -= x[id];
                    sumY -= y[id];
                }
            }
            it++;
        }

        prevAngle = curAngle;
    }

    if (TWO_PI > prevAngle + 1e-18L) {
        considerInterval(prevAngle, TWO_PI, sumX, sumY);
    }
    long double ux = cosl(bestTheta), uy = sinl(bestTheta);
    const long double EPS = 1e-12L;

    vector<int> picked;
    picked.reserve(n);

    for (int i = 1; i <= n; i++) {
        if (x[i] == 0 && y[i] == 0) continue;
        long double proj = ux * (long double)x[i] + uy * (long double)y[i];
        if (proj > EPS) picked.push_back(i);
    }

    cout << picked.size() << "\n";
    for (int i = 0; i < (int)picked.size(); i++) {
        if (i) cout << ' ';
        cout << picked[i];
    }
    cout << "\n";

    return 0;
}